USE [BMS_DW]
GO
/****** Object:  StoredProcedure [dbo].[usp_ETL_Incremental_UpdateFactWaitingList]    Script Date: 4/29/2016 11:52:30 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- Stored Procedure

ALTER PROCEDURE [dbo].[usp_ETL_Incremental_UpdateFactWaitingList]
@END_DATE DATETIME, @SOURCE_DB NVARCHAR(250)
AS
BEGIN

	SET NOCOUNT ON;

	BEGIN TRY
	
	DECLARE @SQL VARCHAR(max), @START_DATE DATETIME, @FROM_CLAUSE NVARCHAR(MAX), @INDEX INT, @ROWS INT
	
	--TRUNCATE TABLE FACT_WAITING_LIST_ETL
	IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FACT_WAITING_LIST_ETL]'))
	BEGIN
		TRUNCATE TABLE FACT_WAITING_LIST_ETL
	END
	
	SELECT @START_DATE = ISNULL(max(_ssis_timestamp), '1900-01-01') FROM FACT_WAITING_LIST
	SET @INDEX = CHARINDEX('.', @SOURCE_DB)		
	
	IF @INDEX = 0
		SET @FROM_CLAUSE = @SOURCE_DB + '.[dbo].[ufn_ETL_Fact_Waiting_List](''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''', ''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''')'
	ELSE
		SET @FROM_CLAUSE = 'OPENQUERY( ' + SUBSTRING(@SOURCE_DB, 0, @INDEX) + ', ''SELECT * FROM ' + SUBSTRING(@SOURCE_DB, @INDEX + 1, LEN(@SOURCE_DB)) + 
					'.[dbo].[ufn_ETL_Fact_Waiting_List](''''' + CONVERT(NVARCHAR(50),@START_DATE,109) + ''''', ''''' + CONVERT(NVARCHAR(50),@END_DATE,109) + ''''')'')'
		SET @SQL = ''
	SET @SQL = @SQL + '
	INSERT INTO FACT_WAITING_LIST_ETL (SOURCE_ID, FACILITY_ID, VISTA_SITE_ID, WAITING_AREA_CODE, PROBLEM, FEE_DISPOSITION_CODE, CONTRACT_FEE_CODE, AUTHORIZED_FEE_CODE, SERVICE_RECEIVING_FEE_CODE,
		   DIM_REASON_USING_FEE_CODE, FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, REQUESTED_BED_ID, REQUESTED_BED_DATE, REQUESTED_DATE, _SSIS_TIMESTAMP,
		   [IS_IN_HOUSE], [LAST_EDIT_BY], [COMMENTS], IS_BED_IN_ISOLATION, WAIT_TIME_ALERT_DATE, [IS_COMMUNITY_LIVING_CENTER], [IS_EVACUATION_PATIENT],
		   [EVACUATION_DISPOSITION_STATUS_CODE], [EVACUATION_EXPECTED_DATE], [EVACUATION_ACTUAL_DATE], [EVACUATION_REASON_FOR_DELAY], [EVACUATION_TRANSFER_EVACUATE_TO],
		   [EVACUATION_EQUIP_SUPPLY_REQUIREMENTS], [EVACUATION_TRANSPORTATION_CARE_LEVEL], [EVACUATION_ENROUTE_MEDICAL_ATTENDANT], [EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT],
		   [EVACUATION_TRANSPORTATION_TYPE_CODE], [EVACUATION_TRANSPORTATION_PROVIDER_CODE], [EVACUATION_TRANSPORTATION_COMMENTS], [EVACUATION_DESTINATION_ADDRESS],
		   [EVACUATION_DESTINATION_CITY_STATE], [EVACUATION_DESTINATION_POC_TELEPHONE], [EVACUATION_ORIGINATOR_POC_TELEPHONE], [EVACUATION_COMMENTS],
		   EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER, DIM_PATIENT_ID, 		   
		   EVACUATION_ARRIVAL_TIME,
		   EVACUATION_VEHICLE_ID,
		   EVACUATION_VEHICLE_SEAT_POSITION,
		   EVACUATION_MA_TELEPHONE,
		   EVACUATION_NMA_TELEPHONE,
		   EVACUATION_ORIGINATING_FACILITY_NAME,
		   EVACUATION_ORIGINATING_ADDRESS,
		   EVACUATION_ORIGINATING_CITY_STATE,
		   EVACUATION_VEHICLE_OPERATOR_NAME,
		   EVACUATION_VEHICLE_OPERATOR_TELEPHONE) 
	SELECT SOURCE_ID, FACILITY_ID, VISTA_SITE_ID, WAITING_AREA_CODE, PROBLEM, FEE_DISPOSITION_CODE, CONTRACT_FEE_CODE, AUTHORIZED_FEE_CODE, SERVICE_RECEIVING_FEE_CODE,
		   DIM_REASON_USING_FEE_CODE, FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, REQUESTED_BED_ID, REQUESTED_BED_DATE, REQUESTED_DATE, _SSIS_TIMESTAMP,
		   [IS_IN_HOUSE], [LAST_EDIT_BY], [COMMENTS], IS_BED_IN_ISOLATION, WAIT_TIME_ALERT_DATE, [IS_COMMUNITY_LIVING_CENTER], [IS_EVACUATION_PATIENT],
		   [EVACUATION_DISPOSITION_STATUS_CODE], [EVACUATION_EXPECTED_DATE], [EVACUATION_ACTUAL_DATE], [EVACUATION_REASON_FOR_DELAY], [EVACUATION_TRANSFER_EVACUATE_TO],
		   [EVACUATION_EQUIP_SUPPLY_REQUIREMENTS], [EVACUATION_TRANSPORTATION_CARE_LEVEL], [EVACUATION_ENROUTE_MEDICAL_ATTENDANT], [EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT],
		   [EVACUATION_TRANSPORTATION_TYPE_CODE], [EVACUATION_TRANSPORTATION_PROVIDER_CODE], [EVACUATION_TRANSPORTATION_COMMENTS], [EVACUATION_DESTINATION_ADDRESS],
		   [EVACUATION_DESTINATION_CITY_STATE], [EVACUATION_DESTINATION_POC_TELEPHONE], [EVACUATION_ORIGINATOR_POC_TELEPHONE], [EVACUATION_COMMENTS],
		   EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER, DIM_PATIENT_ID,
		   EVACUATION_ARRIVAL_TIME,
		   EVACUATION_VEHICLE_ID,
		   EVACUATION_VEHICLE_SEAT_POSITION,
		   EVACUATION_MA_TELEPHONE,
		   EVACUATION_NMA_TELEPHONE,
		   EVACUATION_ORIGINATING_FACILITY_NAME,
		   EVACUATION_ORIGINATING_ADDRESS,
		   EVACUATION_ORIGINATING_CITY_STATE,
		   EVACUATION_VEHICLE_OPERATOR_NAME,
		   EVACUATION_VEHICLE_OPERATOR_TELEPHONE
	FROM ' + @FROM_CLAUSE	
	EXEC (@SQL)
	
	SET @ROWS = @@ROWCOUNT
	IF @ROWS <> 0
	BEGIN
			UPDATE TBL
				SET 
				[SOURCE_ID] =	FAU.SOURCE_ID
				,[FACILITY_DIM_ORGANIZATION_ID] = DOFACILITY.ID
				,[VISTA_SITE_DIM_ORGANIZATION_ID] =DOVISTASITE.ID
				,[DIM_WAITING_AREA_ID] =WAITING_AREA.ID
				,[PROBLEM] = FAU.PROBLEM 
				,[DIM_FEE_DISPOSITION_ID] = FEE_DISPOSITION.ID
				,[DIM_CONTRACT_FEE_ID] = CONTRACT_FEE.ID
				,[DIM_AUTHORIZED_FEE_ID] = AUTHORIZED_FEE.ID
				,[DIM_SERVICE_RECEIVING_FEE_ID] = SERVICE_RECEIVING_FEE.ID
				,[DIM_REASON_USING_FEE_ID] = REASON_USING_FEE.ID
				,[FEE_COMMENTS] = FAU.FEE_COMMENTS
				,[REMOVED_DATE] = FAU.REMOVED_DATE
				,[TYPE_OF_BED_WARD] = FAU.TYPE_OF_BED_WARD
				,[DIM_REQUESTED_BED_ID] = DB.ID
				,[REQUESTED_BED_DATE] = FAU.REQUESTED_BED_DATE
				,[REQUESTED_DATE] = FAU.REQUESTED_DATE
				,[_SSIS_TIMESTAMP] = FAU._SSIS_TIMESTAMP
				,[IS_IN_HOUSE] = FAU.[IS_IN_HOUSE],
				[LAST_EDIT_BY] = FAU.[LAST_EDIT_BY],
				COMMENTS = FAU.COMMENTS,
				IS_BED_IN_ISOLATION = FAU.IS_BED_IN_ISOLATION,
				WAIT_TIME_ALERT_DATE = FAU.WAIT_TIME_ALERT_DATE,
				[IS_COMMUNITY_LIVING_CENTER] = FAU.[IS_COMMUNITY_LIVING_CENTER], 
				[IS_EVACUATION_PATIENT] = FAU.[IS_EVACUATION_PATIENT],
				[DIM_EVACUATION_DISPOSITION_STATUS_ID] = EVAC_DISPOSITION_STATUS.ID,
				[EVACUATION_EXPECTED_DATE] = FAU.[EVACUATION_EXPECTED_DATE],
				[EVACUATION_ACTUAL_DATE] = FAU.[EVACUATION_ACTUAL_DATE],
				[EVACUATION_REASON_FOR_DELAY] = FAU.[EVACUATION_REASON_FOR_DELAY],
				[EVACUATION_TRANSFER_EVACUATE_TO] = FAU.[EVACUATION_TRANSFER_EVACUATE_TO],
				[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS] = FAU.[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS],
				[EVACUATION_TRANSPORTATION_CARE_LEVEL] = FAU.[EVACUATION_TRANSPORTATION_CARE_LEVEL],
				[EVACUATION_ENROUTE_MEDICAL_ATTENDANT] = FAU.[EVACUATION_ENROUTE_MEDICAL_ATTENDANT],
				[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT] = FAU.[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT],
				[DIM_EVACUATION_TRANSPORTATION_TYPE_ID]	= EVAC_TRANSPORTATION_TYPE.ID,
				[DIM_EVACUATION_TRANSPORTATION_PROVIDER_ID] = EVAC_TRANSPORTATION_PROVIDER.ID,
				[EVACUATION_TRANSPORTATION_COMMENTS] = FAU.[EVACUATION_TRANSPORTATION_COMMENTS],
				[EVACUATION_DESTINATION_ADDRESS] = FAU.[EVACUATION_DESTINATION_ADDRESS],
				[EVACUATION_DESTINATION_CITY_STATE] = FAU.[EVACUATION_DESTINATION_CITY_STATE],
				[EVACUATION_DESTINATION_POC_TELEPHONE] = FAU.[EVACUATION_DESTINATION_POC_TELEPHONE],
				[EVACUATION_ORIGINATOR_POC_TELEPHONE] =	FAU.[EVACUATION_ORIGINATOR_POC_TELEPHONE],
				[EVACUATION_COMMENTS] =	FAU.[EVACUATION_COMMENTS],
				[EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER] =	FAU.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, 
				[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER] =	FAU.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER,
				[EVACUATION_ARRIVAL_TIME] = FAU.EVACUATION_ARRIVAL_TIME,
				[EVACUATION_VEHICLE_ID] = FAU.EVACUATION_VEHICLE_ID,
				[EVACUATION_VEHICLE_SEAT_POSITION] = FAU.EVACUATION_VEHICLE_SEAT_POSITION,
			    [EVACUATION_MA_TELEPHONE] = FAU.EVACUATION_MA_TELEPHONE,
		        [EVACUATION_NMA_TELEPHONE] = FAU.EVACUATION_MA_TELEPHONE,
				[EVACUATION_ORIGINATING_FACILITY_NAME] = FAU.EVACUATION_ORIGINATING_FACILITY_NAME,
				[EVACUATION_ORIGINATING_ADDRESS] = FAU.EVACUATION_ORIGINATING_ADDRESS,
				[EVACUATION_ORIGINATING_CITY_STATE] = FAU.EVACUATION_ORIGINATING_CITY_STATE,
				[EVACUATION_VEHICLE_OPERATOR_NAME] = FAU.EVACUATION_VEHICLE_OPERATOR_NAME,
				[EVACUATION_VEHICLE_OPERATOR_TELEPHONE] = FAU.EVACUATION_VEHICLE_OPERATOR_TELEPHONE,
				[DIM_PATIENT_ID] = PATIENT.ID   
			FROM DBO.FACT_WAITING_LIST TBL
			INNER JOIN FACT_WAITING_LIST_ETL FAU ON TBL.SOURCE_ID = FAU.SOURCE_ID
			INNER JOIN DIM_PATIENT AS PATIENT ON PATIENT.SOURCE_ID = FAU.DIM_PATIENT_ID 
			LEFT JOIN DIM_BED DB ON DB.SOURCE_ID = FAU.REQUESTED_BED_ID	
			LEFT JOIN DIM_ORGANIZATION DOFACILITY ON DOFACILITY.SOURCE_ID = FAU.FACILITY_ID
			LEFT JOIN DIM_ORGANIZATION DOVISTASITE ON DOVISTASITE.SOURCE_ID = FAU.VISTA_SITE_ID
			LEFT JOIN DIM_WAITING_AREA AS WAITING_AREA  ON WAITING_AREA.CODE = FAU.WAITING_AREA_CODE
			LEFT JOIN DIM_FEE_DISPOSITION AS FEE_DISPOSITION  ON FEE_DISPOSITION.CODE = FAU.FEE_DISPOSITION_CODE
			LEFT JOIN DIM_SERVICE_RECEIVING_FEE AS SERVICE_RECEIVING_FEE ON SERVICE_RECEIVING_FEE.CODE = FAU.SERVICE_RECEIVING_FEE_CODE	
			LEFT JOIN DIM_FEE_REASON AS REASON_USING_FEE ON REASON_USING_FEE.CODE = FAU.DIM_REASON_USING_FEE_CODE	
			LEFT JOIN DIM_CONTRACT AS CONTRACT_FEE ON CONTRACT_FEE.CODE = FAU.CONTRACT_FEE_CODE	
			LEFT JOIN DIM_CONTRACT AS AUTHORIZED_FEE ON AUTHORIZED_FEE.CODE = FAU.AUTHORIZED_FEE_CODE
			LEFT JOIN DIM_EVAC_DISPOSITION_STATUS AS EVAC_DISPOSITION_STATUS ON EVAC_DISPOSITION_STATUS.CODE = FAU.EVACUATION_DISPOSITION_STATUS_CODE	
			LEFT JOIN DIM_EVAC_TRANSPORTATION_TYPE AS EVAC_TRANSPORTATION_TYPE ON EVAC_TRANSPORTATION_TYPE.CODE = FAU.EVACUATION_TRANSPORTATION_TYPE_CODE	
			LEFT JOIN DIM_EVAC_TRANSPORTATION_PROVIDER AS EVAC_TRANSPORTATION_PROVIDER ON EVAC_TRANSPORTATION_PROVIDER.CODE = FAU.EVACUATION_TRANSPORTATION_PROVIDER_CODE					
			
			INSERT INTO [FACT_WAITING_LIST]
				([SOURCE_ID]
				,[FACILITY_DIM_ORGANIZATION_ID]
				,[VISTA_SITE_DIM_ORGANIZATION_ID]
				,[DIM_WAITING_AREA_ID]
				,[PROBLEM]
				,[DIM_FEE_DISPOSITION_ID]
				,[DIM_CONTRACT_FEE_ID]
				,[DIM_AUTHORIZED_FEE_ID]
				,[DIM_SERVICE_RECEIVING_FEE_ID]
				,[DIM_REASON_USING_FEE_ID]
				,[FEE_COMMENTS]
				,[REMOVED_DATE]
				,[TYPE_OF_BED_WARD]
				,[DIM_REQUESTED_BED_ID]
				,[REQUESTED_BED_DATE]
				,[REQUESTED_DATE]
				,[_SSIS_TIMESTAMP]
				,[IS_IN_HOUSE],
				[LAST_EDIT_BY],
				[COMMENTS],
				IS_BED_IN_ISOLATION,
				WAIT_TIME_ALERT_DATE,
				[IS_COMMUNITY_LIVING_CENTER], 
				[IS_EVACUATION_PATIENT],
				[DIM_EVACUATION_DISPOSITION_STATUS_ID],
				[EVACUATION_EXPECTED_DATE],
				[EVACUATION_ACTUAL_DATE],
				[EVACUATION_REASON_FOR_DELAY],
				[EVACUATION_TRANSFER_EVACUATE_TO],
				[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS],
				[EVACUATION_TRANSPORTATION_CARE_LEVEL],
				[EVACUATION_ENROUTE_MEDICAL_ATTENDANT],
				[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT],
				[DIM_EVACUATION_TRANSPORTATION_TYPE_ID],
				[DIM_EVACUATION_TRANSPORTATION_PROVIDER_ID],
				[EVACUATION_TRANSPORTATION_COMMENTS],
				[EVACUATION_DESTINATION_ADDRESS],
				[EVACUATION_DESTINATION_CITY_STATE],
				[EVACUATION_DESTINATION_POC_TELEPHONE],
				[EVACUATION_ORIGINATOR_POC_TELEPHONE],
				[EVACUATION_COMMENTS],
				[EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER], 
				[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER],
				[DIM_PATIENT_ID],
			    EVACUATION_ARRIVAL_TIME,
				EVACUATION_VEHICLE_ID,
				EVACUATION_VEHICLE_SEAT_POSITION,
				EVACUATION_MA_TELEPHONE,
				EVACUATION_NMA_TELEPHONE,
				EVACUATION_ORIGINATING_FACILITY_NAME,
				EVACUATION_ORIGINATING_ADDRESS,
				EVACUATION_ORIGINATING_CITY_STATE,
				EVACUATION_VEHICLE_OPERATOR_NAME,
				EVACUATION_VEHICLE_OPERATOR_TELEPHONE
				)
			SELECT 
				FAI.SOURCE_ID,
				DOFACILITY.ID,
				DOVISTASITE.ID,
				WAITING_AREA.ID,
				FAI.PROBLEM,
				FEE_DISPOSITION.ID,
				CONTRACT_FEE.ID,
				AUTHORIZED_FEE.ID,
				SERVICE_RECEIVING_FEE.ID,
				REASON_USING_FEE.ID,
				FAI.FEE_COMMENTS,
				FAI.REMOVED_DATE,
				FAI.TYPE_OF_BED_WARD,
				DB.ID,
				FAI.REQUESTED_BED_DATE,
				FAI.REQUESTED_DATE,
				FAI._SSIS_TIMESTAMP,
				FAI.[IS_IN_HOUSE],
				FAI.[LAST_EDIT_BY],
				FAI.COMMENTS,
				FAI.IS_BED_IN_ISOLATION,
				FAI.WAIT_TIME_ALERT_DATE,
				FAI.[IS_COMMUNITY_LIVING_CENTER], 
				FAI.[IS_EVACUATION_PATIENT],
				EVAC_DISPOSITION_STATUS.ID,
				FAI.[EVACUATION_EXPECTED_DATE],
				FAI.[EVACUATION_ACTUAL_DATE],
				FAI.[EVACUATION_REASON_FOR_DELAY],
				FAI.[EVACUATION_TRANSFER_EVACUATE_TO],
				FAI.[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS],
				FAI.[EVACUATION_TRANSPORTATION_CARE_LEVEL],
				FAI.[EVACUATION_ENROUTE_MEDICAL_ATTENDANT],
				FAI.[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT],
				EVAC_TRANSPORTATION_TYPE.ID,
				EVAC_TRANSPORTATION_PROVIDER.ID,
				FAI.[EVACUATION_TRANSPORTATION_COMMENTS],
				FAI.[EVACUATION_DESTINATION_ADDRESS],
				FAI.[EVACUATION_DESTINATION_CITY_STATE],
				FAI.[EVACUATION_DESTINATION_POC_TELEPHONE],
				FAI.[EVACUATION_ORIGINATOR_POC_TELEPHONE],
				FAI.[EVACUATION_COMMENTS],
				FAI.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, 
				FAI.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER,
				PATIENT.ID,
			    EVACUATION_ARRIVAL_TIME,
				EVACUATION_VEHICLE_ID,
				EVACUATION_VEHICLE_SEAT_POSITION,
				EVACUATION_MA_TELEPHONE,
				EVACUATION_NMA_TELEPHONE,
				EVACUATION_ORIGINATING_FACILITY_NAME,
				EVACUATION_ORIGINATING_ADDRESS,
				EVACUATION_ORIGINATING_CITY_STATE,
				EVACUATION_VEHICLE_OPERATOR_NAME,
				EVACUATION_VEHICLE_OPERATOR_TELEPHONE
			FROM FACT_WAITING_LIST_ETL FAI  
			INNER JOIN DIM_PATIENT AS PATIENT ON PATIENT.SOURCE_ID = fai.DIM_PATIENT_ID 
			LEFT JOIN DIM_BED DB ON DB.SOURCE_ID = FAI.REQUESTED_BED_ID	
			LEFT JOIN DIM_ORGANIZATION DOFACILITY ON DOFACILITY.SOURCE_ID = FAI.FACILITY_ID
			LEFT JOIN DIM_ORGANIZATION DOVISTASITE ON DOVISTASITE.SOURCE_ID = FAI.VISTA_SITE_ID
			LEFT JOIN DIM_WAITING_AREA AS WAITING_AREA  ON WAITING_AREA.CODE = FAI.WAITING_AREA_CODE
			LEFT JOIN DIM_FEE_DISPOSITION AS FEE_DISPOSITION  ON FEE_DISPOSITION.CODE = FAI.FEE_DISPOSITION_CODE
			LEFT JOIN DIM_SERVICE_RECEIVING_FEE AS SERVICE_RECEIVING_FEE ON SERVICE_RECEIVING_FEE.CODE = FAI.SERVICE_RECEIVING_FEE_CODE	
			LEFT JOIN DIM_FEE_REASON AS REASON_USING_FEE ON REASON_USING_FEE.CODE = FAI.DIM_REASON_USING_FEE_CODE	
			LEFT JOIN DIM_CONTRACT AS CONTRACT_FEE ON CONTRACT_FEE.CODE = FAI.CONTRACT_FEE_CODE	
			LEFT JOIN DIM_CONTRACT AS AUTHORIZED_FEE ON AUTHORIZED_FEE.CODE = FAI.AUTHORIZED_FEE_CODE	
			LEFT JOIN DIM_EVAC_DISPOSITION_STATUS AS EVAC_DISPOSITION_STATUS ON EVAC_DISPOSITION_STATUS.CODE = FAI.EVACUATION_DISPOSITION_STATUS_CODE	
			LEFT JOIN DIM_EVAC_TRANSPORTATION_TYPE AS EVAC_TRANSPORTATION_TYPE ON EVAC_TRANSPORTATION_TYPE.CODE = FAI.EVACUATION_TRANSPORTATION_TYPE_CODE	
			LEFT JOIN DIM_EVAC_TRANSPORTATION_PROVIDER AS EVAC_TRANSPORTATION_PROVIDER ON EVAC_TRANSPORTATION_PROVIDER.CODE = FAI.EVACUATION_TRANSPORTATION_PROVIDER_CODE					
			WHERE NOT EXISTS ( SELECT 1 FROM FACT_WAITING_LIST WHERE SOURCE_ID = FAI.SOURCE_ID)
	END

	RETURN @ROWS

END TRY
BEGIN CATCH		
		
		DECLARE @ErrorMessage NVARCHAR(4000), @ErrorSeverity INT, @ErrorState INT;
				
		SELECT @ErrorMessage = '*** ERROR in usp_ETL_Incremental_UpdateFactWaitingList: ' + ERROR_MESSAGE(),
			   @ErrorSeverity = ERROR_SEVERITY(),
			   @ErrorState = ERROR_STATE();

		RAISERROR (@ErrorMessage,  @ErrorSeverity, @ErrorState) WITH LOG;
END CATCH	
END
